(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23233,        887]*)
(*NotebookOutlinePosition[     24073,        914]*)
(*  CellTagsIndexPosition[     24029,        910]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->12,
  FontSize->16],

Cell[StyleData[All, "Condensed"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Margins"->{1, 1},
  "Widths"->{0, 5}},
  ScriptMinSize->8,
  FontSize->11],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->5,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{12, Inherited}, {20, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold"],

Cell[StyleData["Title", "Presentation"],
  CellMargins->{{24, 10}, {20, 40}},
  LineSpacing->{1, 0},
  FontSize->44],

Cell[StyleData["Title", "Condensed"],
  CellMargins->{{8, 10}, {4, 8}},
  FontSize->20],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{2, 10}, {12, 30}},
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{12, Inherited}, {20, 15}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{24, 10}, {20, 20}},
  LineSpacing->{1, 0},
  FontSize->36],

Cell[StyleData["Subtitle", "Condensed"],
  CellMargins->{{8, 10}, {4, 4}},
  FontSize->14],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {12, 8}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{12, Inherited}, {20, 15}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{24, 10}, {20, 20}},
  LineSpacing->{1, 0},
  FontSize->24],

Cell[StyleData["Subsubtitle", "Condensed"],
  CellMargins->{{8, 10}, {8, 8}},
  FontSize->12],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {12, 8}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{25, Inherited}, {8, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
  CellMargins->{{40, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->24],

Cell[StyleData["Section", "Condensed"],
  CellMargins->{{18, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{13, 0}, {7, 22}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{22, Inherited}, {8, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{36, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsection", "Condensed"],
  CellMargins->{{16, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {7, 22}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{22, Inherited}, {8, 18}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Subsubsection", "Condensed"],
  CellMargins->{{17, Inherited}, {6, 12}},
  FontSize->10],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{9, 0}, {7, 14}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5}],

Cell[StyleData["Text", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{12, 10}, {6, 6}},
  LineSpacing->{1, 3},
  CounterIncrements->"SmallText",
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->12],

Cell[StyleData["SmallText", "Condensed"],
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{72, Inherited}, {8, 10}},
  LineSpacing->{1, 0}],

Cell[StyleData["Input", "Condensed"],
  CellMargins->{{40, 10}, {2, 3}}],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Closed]],

Cell[StyleData["InputOnly"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{72, Inherited}, {10, 8}},
  LineSpacing->{1, 0}],

Cell[StyleData["Output", "Condensed"],
  CellMargins->{{41, Inherited}, {3, 2}}],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Message", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Print", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{4, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  ImageMargins->{{62, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Condensed"],
  ImageMargins->{{38, Inherited}, {Inherited, 0}},
  Magnification->0.6],

Cell[StyleData["Graphics", "Printout"],
  ImageMargins->{{30, Inherited}, {Inherited, 0}},
  FontSize->9,
  Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["CellLabel", "Condensed"],
  FontSize->9],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True],

Cell[StyleData["InlineFormula", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5}],

Cell[StyleData["InlineFormula", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["InlineFormula", "Printout"],
  CellMargins->{{2, 0}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  LineSpacing->{1, 5}],

Cell[StyleData["DisplayFormula", "Condensed"],
  LineSpacing->{1, 1}],

Cell[StyleData["DisplayFormula", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontSize->10,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"]],

Cell[StyleData["Hyperlink", "Condensed"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"]],

Cell[StyleData["MainBookLink", "Condensed"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"]],

Cell[StyleData["AddOnsLink", "Condensed"]],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"]],

Cell[StyleData["RefGuideLink", "Condensed"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"]],

Cell[StyleData["GettingStartedLink", "Condensed"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"]],

Cell[StyleData["OtherInformationLink", "Condensed"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->True,
  StyleMenuListing->None],

Cell[StyleData["Placeholder", "Presentation"]],

Cell[StyleData["Placeholder", "Condensed"]],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SelectionPlaceholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->Primary,
  StyleMenuListing->None,
  DrawHighlighted->True],

Cell[StyleData["SelectionPlaceholder", "Presentation"]],

Cell[StyleData["SelectionPlaceholder", "Condensed"]],

Cell[StyleData["SelectionPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontSize->12,
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  AllowInlineCells->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{0.6, 1},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  TextAlignment->Left,
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[1, 0.749996, 0.8]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{487, 314},
WindowMargins->{{11, Automatic}, {Automatic, 2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 62, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 99, 3, 40, 36, 0, "StyleData", "All", "Presentation"],
Cell[2216, 72, 158, 5, 35, 33, 0, "StyleData", "All", "Condensed"],
Cell[2377, 79, 140, 4, 34, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2554, 88, 35, 0, 30, "Section"],
Cell[2592, 90, 101, 3, 30, "Text"],
Cell[2696, 95, 426, 11, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3159, 111, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3222, 115, 347, 9, 112, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3572, 126, 116, 3, 120, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3691, 131, 87, 2, 48, 37, 0, "StyleData", "Title", "Condensed"],
Cell[3781, 135, 88, 2, 83, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3906, 142, 315, 8, 65, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4224, 152, 119, 3, 92, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[4346, 157, 90, 2, 38, 40, 0, "StyleData", "Subtitle", "Condensed"],
Cell[4439, 161, 90, 2, 54, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4566, 168, 317, 8, 54, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4886, 178, 122, 3, 80, 46, 0, "StyleData", "Subsubtitle", 
"Presentation"],
Cell[5011, 183, 93, 2, 45, 43, 0, "StyleData", "Subsubtitle", "Condensed"],
Cell[5107, 187, 93, 2, 50, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5237, 194, 336, 9, 44, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5576, 205, 118, 3, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[5697, 210, 98, 2, 70, 39, 0, "StyleData", "Section", "Condensed"],
Cell[5798, 214, 89, 2, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5924, 221, 301, 8, 42, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[6228, 231, 121, 3, 81, 45, 0, "StyleData", "Subsection", "Presentation"],

Cell[6352, 236, 101, 2, 47, 42, 0, "StyleData", "Subsection", "Condensed"],
Cell[6456, 240, 91, 2, 58, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6584, 247, 245, 6, 41, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[6832, 255, 124, 3, 71, 48, 0, "StyleData", "Subsubsection", 
"Presentation"],
Cell[6959, 260, 104, 2, 44, 45, 0, "StyleData", "Subsubsection", "Condensed"],

Cell[7066, 264, 94, 2, 48, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7209, 272, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[7273, 276, 110, 3, 42, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[7386, 281, 99, 2, 48, 39, 0, "StyleData", "Text", "Presentation"],
Cell[7488, 285, 93, 2, 40, 36, 0, "StyleData", "Text", "Condensed"],
Cell[7584, 289, 68, 1, 40, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7689, 295, 162, 5, 36, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[7854, 302, 118, 3, 45, 44, 0, "StyleData", "SmallText", "Presentation"],
Cell[7975, 307, 113, 3, 36, 41, 0, "StyleData", "SmallText", "Condensed"],
Cell[8091, 312, 88, 2, 33, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8228, 320, 42, 0, 30, "Section"],
Cell[8273, 322, 364, 6, 78, "Text"],

Cell[CellGroupData[{
Cell[8662, 332, 434, 13, 42, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[9099, 347, 106, 2, 47, 40, 0, "StyleData", "Input", "Presentation"],
Cell[9208, 351, 72, 1, 34, 37, 0, "StyleData", "Input", "Condensed"],
Cell[9283, 354, 85, 2, 35, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[9383, 359, 309, 10, 38, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[9717, 373, 454, 13, 40, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[10174, 388, 107, 2, 46, 41, 0, "StyleData", "Output", "Presentation"],
Cell[10284, 392, 80, 1, 33, 38, 0, "StyleData", "Output", "Condensed"],
Cell[10367, 395, 86, 2, 36, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10490, 402, 501, 14, 36, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[10994, 418, 123, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[11120, 422, 97, 1, 70, 39, 0, "StyleData", "Message", "Condensed"],
Cell[11220, 425, 138, 3, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11395, 433, 465, 13, 36, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[11863, 448, 121, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[11987, 452, 95, 1, 70, 37, 0, "StyleData", "Print", "Condensed"],
Cell[12085, 455, 109, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12231, 462, 439, 12, 36, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[12673, 476, 94, 1, 36, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[12770, 479, 113, 2, 27, 40, 0, "StyleData", "Graphics", "Condensed"],
Cell[12886, 483, 127, 3, 29, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13050, 491, 128, 4, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[13181, 497, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[13244, 500, 56, 1, 70, 41, 0, "StyleData", "CellLabel", "Condensed"],
Cell[13303, 503, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13482, 513, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[13550, 517, 146, 4, 36, 32, 0, "StyleData", "InlineFormula", "All"],
Cell[13699, 523, 108, 2, 48, 48, 0, "StyleData", "InlineFormula", 
"Presentation"],
Cell[13810, 527, 102, 2, 40, 45, 0, "StyleData", "InlineFormula", 
"Condensed"],
Cell[13915, 531, 77, 1, 40, 44, 0, "StyleData", "InlineFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14029, 537, 272, 6, 36, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[14304, 545, 72, 1, 36, 49, 0, "StyleData", "DisplayFormula", 
"Presentation"],
Cell[14379, 548, 69, 1, 36, 46, 0, "StyleData", "DisplayFormula", 
"Condensed"],
Cell[14451, 551, 45, 0, 36, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14545, 557, 49, 0, 30, "Section"],
Cell[14597, 559, 123, 4, 31, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[14723, 565, 122, 4, 29, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[14848, 571, 127, 4, 32, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[15012, 580, 33, 0, 30, "Section"],
Cell[15048, 582, 121, 3, 70, "Text"],
Cell[15172, 587, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[15401, 594, 295, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[15699, 603, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[16102, 614, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[16492, 625, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[16930, 639, 35, 0, 30, "Section"],
Cell[16968, 641, 184, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[17177, 649, 302, 8, 36, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17482, 659, 44, 0, 70, 44, 0, "StyleData", "Hyperlink", "Presentation"],
Cell[17529, 661, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[17573, 663, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[17695, 668, 104, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[17824, 675, 316, 8, 36, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18143, 685, 47, 0, 70, 47, 0, "StyleData", "MainBookLink", 
"Presentation"],
Cell[18193, 687, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "Condensed"],
Cell[18240, 689, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[18387, 696, 337, 9, 36, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18727, 707, 45, 0, 36, 45, 0, "StyleData", "AddOnsLink", "Presentation"],

Cell[18775, 709, 42, 0, 36, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[18820, 711, 107, 2, 36, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[18964, 718, 345, 9, 36, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19312, 729, 47, 0, 70, 47, 0, "StyleData", "RefGuideLink", 
"Presentation"],
Cell[19362, 731, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "Condensed"],
Cell[19409, 733, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[19556, 740, 328, 8, 36, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19887, 750, 53, 0, 70, 53, 0, "StyleData", "GettingStartedLink", 
"Presentation"],
Cell[19943, 752, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", 
"Condensed"],
Cell[19996, 754, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20149, 761, 332, 8, 36, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20484, 771, 55, 0, 70, 55, 0, "StyleData", "OtherInformationLink", 
"Presentation"],
Cell[20542, 773, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", 
"Condensed"],
Cell[20597, 775, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20764, 783, 37, 0, 30, "Section"],
Cell[20804, 785, 115, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[20944, 792, 145, 5, 70, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[21092, 799, 46, 0, 70, 46, 0, "StyleData", "Placeholder", 
"Presentation"],
Cell[21141, 801, 43, 0, 70, 43, 0, "StyleData", "Placeholder", "Condensed"],
Cell[21187, 803, 42, 0, 70, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21266, 808, 182, 6, 70, 39, 0, "StyleData", "SelectionPlaceholder", 
"All",
  StyleMenuListing->None],
Cell[21451, 816, 55, 0, 70, 55, 0, "StyleData", "SelectionPlaceholder", 
"Presentation"],
Cell[21509, 818, 52, 0, 70, 52, 0, "StyleData", "SelectionPlaceholder", 
"Condensed"],
Cell[21564, 820, 51, 0, 70, 51, 0, "StyleData", "SelectionPlaceholder", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21664, 826, 36, 0, 30, "Section"],
Cell[21703, 828, 305, 5, 78, "Text"],
Cell[22011, 835, 314, 10, 36, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[22328, 847, 106, 3, 36, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[22437, 852, 151, 5, 36, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[22591, 859, 108, 3, 36, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[22702, 864, 179, 5, 36, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[22884, 871, 115, 3, 30, "Text"],
Cell[23002, 876, 96, 3, 36, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[23101, 881, 104, 2, 52, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

